/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.api.VWRouteDefinition;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWRouteListCellRenderer
extends JLabel
implements ListCellRenderer {
    public VWRouteListCellRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list != null && value != null) {
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof VWRouteDefinition) {
                this.setText(VWRouteListCellRenderer.toString((VWRouteDefinition)value));
            }
        } else {
            this.setText("");
        }
        return this;
    }

    public static String toString(VWRouteDefinition routeDef) {
        String name = routeDef.getName();
        if (name == null) {
            name = VWRouteListCellRenderer.getBlankName(routeDef);
        }
        return name;
    }

    public static String getBlankName(VWRouteDefinition routeDef) {
        int nId = routeDef.getRouteId() + 1;
        return VWResource.s_blankRouteLabel.toString(Integer.toString(nId));
    }
}

